# ilastNot {#ilastnot}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ilastNot(X)`

## Arguments {#arguments}

**X** is a vector, or a tuple of vectors of equal length, or a matrix.

## Details {#details}

If *X* is a vector, return the subscript of the last non-null element. Return -1 if all elements are null.

If *X* is a tuple of vectors, return the subscript of the last position where the element in all vectors is not null.

If *X* is a matrix, return the subscript of the last non-null element within each column. The result is a vector.

## Examples {#examples}

```
ilastNot(NULL NULL 2 4 8 1 NULL);
// output: 5

ilastNot(take(int(),5));
// output: -1

x=NULL NULL 4 7 8 NULL
y=1 NULL NULL 4 NULL NULL
ilastNot([x,y]);
// output: 3

x=NULL NULL 4 7 8 NULL
y=1 2 NULL NULL NULL 6
ilastNot([x,y]);
// output: -1

m=matrix(2 NULL 1 0 NULL, NULL 2 NULL 6 0);
m;
```

|\#0|\#1|
|---|---|
|2||
||2|
|1||
|0|6|
||0|

```
ilastNot(m);
// output: [3,4]
```

Related functions: [ifirstNot](ifirstNot.md), [lastNot](../l/lastNot.md), [firstNot](../f/firstNot.md)

