# ifirstNot {#ifirstnot}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ifirstNot(X)`

## Arguments {#arguments}

**X** is a vector, or a tuple of vectors of equal length, or a matrix.

## Details {#details}

If *X* is a vector, return the subscript of the first non-null element. Return -1 if all elements are null.

If *X* is a tuple of vectors, return the subscript of the first position where the element in all vectors is not null.

If *X* is a matrix, return the subscript of the first non-null element within each column. The result is a vector.

## Examples {#examples}

```
ifirstNot(NULL NULL 2 4 8 NULL 1);
// output: 2

ifirstNot(take(int(),5));
// output: -1

x=NULL NULL 4 7 8 NULL
y=1 NULL NULL 4 NULL NULL
ifirstNot([x,y]);
// output: 3

x=NULL NULL 4 7 8 NULL
y=1 2 NULL NULL NULL 6
ifirstNot([x,y]);
// output: -1

m=matrix(0 NULL 1 2 3, NULL 2 NULL 0 3);
m;
```

|\#0|\#1|
|---|---|
|0||
||2|
|1||
|2|0|
|3|3|

```
ifirstNot(m);
// output: [0,1]
```

Related functions: [ilastNot](ilastNot.md), [firstNot](../f/firstNot.md), [lastNot](../l/lastNot.md)

