# ifirstHit {#ifirsthit}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ifirstHit(func, X, target)`

## Arguments {#arguments}

**func** can only be the following operators: `>`, `>=`, `<`, `<=`, `!=`, `<>`, `==`.

**X** is a vector/matrix/table.

**target** is a scalar of the same type as *X* indicating the value to be compared with *X*.

## Details {#details}

Return the index of the first element in *X* that satisfies the condition `X func target` \(e.g. X&gt;5\).

If no element in *X* satisfies the condition, return -1.

Null values are ignored in `ifirstHit`.

-   Use [ifirstNot](ifirstNot.md) to find the index of the first non-null value.

-   Use [find](../f/find.md) to find the index of the first null value.


## Examples {#examples}

```
X = NULL 3.2 4.5 1.2 NULL 7.8 0.6 9.1
ifirstHit(<, X, 2.5)
// output: 3

 // return -1 if no element in X satisfies the condition.
ifirstHit(>, X, 10.0)
// output: -1
```

Related function: [firstHit](../f/firstHit.md)

