# ifValid {#ifvalid}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ifValid(X, Y)`

## Arguments {#arguments}

**X** is a scalar/pair/vector/matrix.

**Y** is a scalar/pair/vector/matrix.

*X* and *Y* must have the same data type.

## Details {#details}

Determine whether *X* is valid. If it is valid, the value of *X* is returned; if it is null, the value of *Y* is returned.

## Examples {#examples}

```
x = take(1..5 join NULL 6,7)
y = 1..7
ifValid(x,y)
// output: [1,2,3,4,5,6,6]
```

``` {#codeblock_xl3_zkf_hzb}

x1 = int(take(1..5 join int(),6))$2:3
y1 = int(take(100,6))$2:3
ifValid(x1,y1)
```

|col1|col2|col3|
|----|----|----|
|1|3|5|
|2|4|100|

If *X* is a vector and *Y* is a matrix with n rows and m columns, the length of *X* is n\*m.

```
m=int(take(1..4 join NULL 8,6))
ifValid(m,y1)
// output: [1,2,3,4,100,8]
```

