# ifNull {#ifnull}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ifNull(X, Y)`

## Arguments {#arguments}

**X** is a scalar/pair/vector/matrix.

**Y** is a scalar/pair/vector/matrix.

*X* and *Y* must have the same data type.

## Details {#details}

Determine whether *X* is null. If it is null, return *X*; if not, return *Y*.

## Examples {#examples}

```
x = take(1..5 join NULL 6,7)
y = 1..7
ifNull(x,y)
// output: [1,2,3,4,5,,7]

y1 = int(take(1..5 join int(),6))$2:3
x1 = int(take(100,6))$2:3
ifNull(x1,y1)

/* output:
#0 #1 #2
-- -- --
1  3  5 
2  4   
*/
```

If *X* is a vector and *Y* is a matrix with n rows and m columns, the length of *X* is n\*m.

```
m=int(take(1..4 join NULL 8,6))
ifNull(m,y1)
// output: [1,2,3,4,,]
```

