# groups {#groups}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`groups(X, \[mode='dict'\])`

## Arguments {#arguments}

**X** is a vector.

**mode** \(optional\) indicates the data form returned by the function. It can be:

-   "dict" \(default\): return a dictionary. The key of the dictionary stores the unique value in *X*; the value is a vector that stores the indices of all elements that hold the value.

-   "table": return a table with 2 columns, "key" and "index", storing the unique value in *X* and the corresponding indices.

-   "vector": return an array vector. The elements are the indices of each unique value in *X*, sorted in ascending order.

-   "tuple": return a tuple. The elements are stored the same as mode="vector".


## Details {#details}

For each unique value in *X*, return the indices of all elements that hold the value.

-   If *mode* = "dict", return a dictionary.
-   If *mode* = "table", return a table with 2 columns, key and index. Each cell in the column index is an array vector.

## Examples {#examples}

```
x=NULL NULL 12 15 12 16 15 14 NULL NULL
groups(x);

/* output:
16->[5]
->[0,1,8,9]
12->[2,4]
14->[7]
15->[3,6]
*/


groups\(x, "vector"\)
// output: \[\[0,1,8,9\],\[2,4\],\[7\],\[3,6\],\[5\]\]

groups\(x, "tuple"\)
// output: \(\[0,1,8,9\],\[2,4\],\[7\],\[3,6\],\[5\]\)

groups\(x, "table"\)
```

|key|index|
|---|-----|
||\[0,1,8,9\]|
|2|\[2,4\]|
|4|\[7\]|
|5|\[3,6\]|
|6|\[5\]|

