# gram {#gram}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`gram(ds, [colNames], [subMean], [normalize])`

## Arguments {#arguments}

**ds** is one or multiple data source. It is usually generated by function [sqlDS](../s/sqlDS.md).

**colNames** \(optional\) is a STRING vector indicating column names. The default value is all columns names in *ds*.

**subMean** \(optional\) is a Boolean value indicating whether to substract from each column its mean. The default value is true.

**normalize** \(optional\) is a Boolean value indicating whether to divide each column by its standard deviation. The default value is false.

## Details {#details}

Calculate the Gram matrix of the selected columns in the given table. With a given matrix A, the result is `A.tranpose() dot A`.

## Examples {#examples}

```
x = [7,1,1,0,5,2]
y = [0.7, 0.9, 0.01, 0.8, 0.09, 0.23]
t=table(x, y)
ds = sqlDS(<select * from t>);
gram(ds);
```

|\#0|\#1|
|---|---|
|37.333333|-0.56|
|-0.56|0.75895|

