# gmd5 {#gmd5}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`gmd5(X)`

## Arguments {#arguments}

**X** is a scalar/vector/tuple/array vector/pair/matrix.

## Details {#details}

Create an MD5 hash from all elements of *X*.

**Return Value:** A scalar of INT128 type

## Examples {#examples}

``` {#codeblock_cyd_njf_c2c}
gmd5([1 2 3])
// output: 2a1dd1e1e59d0a384c26951e316cd7e6

gmd5([[1, 2], 3])
// Since the data used to construct the MD5 is identical, the output will also be identical.
// output: 2a1dd1e1e59d0a384c26951e316cd7e6

xs = array(INT[], 0, 10).append!([1 2 3, 4 5, 6 7 8, 9 10])
gmd5(xs)
// output: c457b6addd2869161f8a853c0f247aaf

ys = [1 2 3, 4 5, 6 7 8, 9 10]
gmd5(ys)
// output: c457b6addd2869161f8a853c0f247aaf

m=matrix(1 2 3, 8 7 0)
gmd5(m)
// output: 660a82bc074f9dccc5c9fbb806f44f5c
```

Related functions: [rowGmd5](../r/rowgmd5.md)

