# getStreamTables {#getstreamtables}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getStreamTables([option=0])`

## Arguments {#arguments}

**option** \(optional\) is an integral scalar indicating the type of the stream table to be obtained. It can take the following values:

-   0: all stream tables;

-   1: persisted stream tables;

-   2: non-persisted stream tables;


## Details {#details}

Get the information of specified stream tables. It returns a table containing the following columns:

-   name: Table name.
-   shared: Whether the table is shared.
-   persisted: Whether the table is persisted.
-   cachePurgeEnabled: Whether cache purge is enabled.
-   loaded: Whether the table is loaded into memory.
-   columns: The number of columns.
-   rowsInMemory: The number of rows in memory.
-   totalRows: The total number of rows.
-   memoryUsed: Memory used \(in bytes\).

Note: If the persisted table has not been loaded to memory, only "name", "persisted", and "loaded" columns are returned. Null values are returned for the rest of columns.

## Examples {#examples}

``` {#codeblock_snq_2nj_b1c}
id=`XOM`GS`AAPL;
x=102.1 33.4 73.6;

rt=streamTable(id, x);
share streamTable(10:0,`time`sym`price`volume,[TIMESTAMP,SYMBOL,DOUBLE,INT]) as trades1;
share streamTable(10:0,`time`sym`price`volume,[TIMESTAMP,SYMBOL,DOUBLE,INT]) as trades2;

getStreamTables()
```

Output:

|name|shared|persisted|cachePurgeEnabled|loaded|columns|rowsInMemory|totalRows|memoryUsed|
|----|------|---------|-----------------|------|-------|------------|---------|----------|
|rt|false|false|false|true|2|3|3|152|
|trades1|true|false|false|true|4|0|0|240|
|trades2|true|false|false|true|4|0|0|240|

