# getClusterTDEKeys {#getclustertdekeys}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getClusterTDEKeys()`

## Arguments {#arguments}

None

## Details {#details}

\[Linux Only\] This function retrieves encryption information for encrypted tables in the cluster.

**Return value:**It returns a table with the following columns:

-   tableName: name of the encrypted table.
-   mode: encryption mode in uppercase.
-   version: TDE key version.

**Note:**When executed by an administrator or a user with DB\_MANAGE privileges, the function returns encryption information for all encrypted tables in the cluster. Otherwise, it only returns encryption information for tables that the user has access to. Access privileges include: `DB_MANAGE`, `DBOBJ_CREATE`, `DB_OWNER`, `TABLE_READ`, `TABLE_WRITE`, `TABLE_INSERT`, `TABLE_UPDATE`, `TABLE_DELETE`, `DB_READ`, `DB_WRITE`, `DB_INSERT`, `DB_UPDATE`, `DB_DELETE`.

## Examples {#examples}

``` {#codeblock_ubz_pks_c2c}
getClusterTDEKeys()
```

|**tableName**|**mode**|**version**|
|-------------|--------|-----------|
|dfs://db/table1|`AES_128_CTR`|3,698,850,997|
|dfs://db/table2|`AES_128_CTR`|5,768,669,747|

