# getUserPasswordStatus {#getUserPasswordStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getUserPasswordStatus([user])`

## Arguments {#arguments}

**user**\(optional\) is a string indicating a user name.

## Details {#details}

Retrieve the password status of the specified user. If *user* is unspecified, the password status of all users in the system except for admin is returned.

Return value: A table with the following columns:

-   user: The username.
-   setTime: The time when the current password was set.
-   expireTime: The password expiration time.
-   authMode: The authentication method, which can be either "SHA256" or "SCRAM".

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getUserPasswordStatus(`user1)
```

|user|setTime|expireTime|authMode|
|----|-------|----------|--------|
|user1|2025.03.27 11:51:09.154259866|2025.04.26 11:51:09.154259866|SHA256|

