# getUserAccessByCluster {#getUserAccessByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getUserAccessByCluster(users, cluster, finalAccess)`

## Arguments {#arguments}

**users** is a STRING vector indicating the usernames.

**cluster** is a STRING scalar indicating the name of the cluster where the users reside.

**finalAccess** is a BOOLEAN scalar indicating whether to return the privileges that ultimately take effect, i.e., the privileges for both the user and the groups the user belongs to are taken into account.

## Details {#details}

Get the privileges for specified users in a multi-cluster environment. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A table. See function [getUserAccess](getUserAccess.md) for details.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getUserAccessByCluster(["admin"], "masterOfMaster", true) 
```

|userId|groups|isAdmin|ACCESS\_READ|ACCESS\_INSERT|ACCESS\_UPDATE|ACCESS\_DELETE|VIEW\_EXEC|SCRIPT\_EXEC|TEST\_EXEC|DBOBJ\_CREATE|...|
|------|------|-------|------------|--------------|--------------|--------------|----------|------------|----------|-------------|---|
|admin||1|allow|allow|allow|allow|allow|allow|allow|allow|...|

Releated Function: [getUserAccess](getUserAccess.md)

