# getUdfEngineVariable {#getUdfEngineVariable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getUdfEngineVariable(engine, name)`

## Details {#topic_wkz_mrp_mgc}

Query the current value of a specified external variable in a given `DStream::udfEngine`.

**Return value**: The current value of the specified variable. Its type and format depend on the variable itself.

## Arguments {#arguments}

**engine**A STRING scalar indicating the name of the user-defined engine created in the stream graph by `DStream::udfEngine`.

**name**A STRING scalar indicating the name of the external variable, which must be one of the variables defined in *variableNames* when creating `DStream::udfEngine.`

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
def callTimes(mutable cnt, msg) {
    cnt += 1;
    return msg
}
g = createStreamGraph("indicators")
g.source("trade", 1024:0, `price`volume, [DOUBLE,INT])
    .udfEngine(callTimes, [`price,`volume] ,[`number], [5])
    .setEngineName("udf")
    .sink("output111")
g.submit()

go
n = 1000
price = rand(100, n)
volume = rand(1000, n)
t = table(price, volume)
appendOrcaStreamTable("trade", t)

// Obtain the current value of number
useOrcaStreamEngine("udf", getUdfEngineVariable, "number")
// output: 1005
```

**Related function:** [DStream::udfEngine](../d/DStream_udfEngine.md)

