# getTabletsMeta {#gettabletsmeta}

## Syntax {#syntax}

`getTabletsMeta([chunkPath],[tableName],[diskUsage=false],[top=124])`

## Arguments {#arguments}

**chunkPath** \(optional\) is the DFS path to one or multiple database chunks. It supports wildcards %, \* and ?.

**tableName** \(optional\) is a string indicating a table name.

**diskUsage** \(optional\) is a Boolean value indicating whether the result includes the column of diskUsage.

**top** \(optional\) is a positive number indicating the maximum number of chunks in the output. The default value is 1024. To remove the upper limit of chunks in the output, set top to -1.

## Details {#details}

Return metadata of specified tablet chunks on the local node. To get metadata about all tablet chunks of a distributed table, use `getTabletsMeta` together with [pnodeRun](../p/pnodeRun.md).

Return a table with the following columns:

-   chunkId: the unique identifier of chunk.

-   path: the physical path of the partition.

-   dfsPath: the dfs path of the partition.

-   tableName: the table name.

-   version: the version number.

-   rowNum: the number of records in the partition.

-   createCids: the Cids created when updating/deleting the table.

-   latestPhysicalDir: the temporary physical directory storing the data generated by the operation with the latest Cid.

-   diskUsage: the disk space occupied by partition \(in Bytes\).


## Examples {#examples}

```
if(existsDatabase("dfs://testDB")){
   dropDatabase("dfs://testDB")
}
db=database("dfs://testDB", VALUE, 1..10)
n=1000000
t=table(rand(1..10, n) as id, rand(100.0, n) as x)
db.createPartitionedTable(t, `pt1, `id).append!(t)
n=2000000
t=table(rand(1..10, n) as id, rand(100.0, n) as x, rand(100, n) as y)
db.createPartitionedTable(t, `pt2, `id).append!(t)
update loadTable("dfs://testDB",`pt1) set x=x*10
getTabletsMeta("/testDB/%", `pt1, true);
```

|chunkId|path|dfsPath|tableName|version|rowNum|createCids|latestPhysicalDir|
|-------|----|-------|---------|-------|------|----------|-----------------|
|dbfd1767-f9ca-689e-4d5e-643b8506e82d|C:UsersDownl...|/testDB/10|pt1|2|99815|\[2059\]|pt1\_2\_2059|
|d221b457-fa7b-5990-4caa-13c99f56f716|C:UsersDownl...|/testDB/9|pt1|2|99975|\[2059\]|pt1\_2\_2059|
|92904d3b-0147-9bb8-4a28-f99525b250e7|C:UsersDownl...|/testDB/8|pt1|2|99844|\[2059\]|pt1\_2\_2059|
|7478c15a-0629-c8ab-47ee-a1d12c3c1cd6|C:UsersDownl...|/testDB/1|pt1|2|100237|\[2059\]|pt1\_2\_2059|
|8bc48c11-86ca-97ac-4ee4-8f829de92cc8|C:UsersDownl...|/testDB/5|pt1|2|99991|\[2059\]|pt1\_2\_2059|
|6b3a0a09-bc64-3bab-4535-344b7316d244|C:UsersDownl...|/testDB/2|pt1|2|100120|\[2059\]|pt1\_2\_2059|
|a7452c44-5d2b-6f82-4150-7bc48e941d64|C:UsersDownl...|/testDB/4|pt1|2|99535|\[2059\]|pt1\_2\_2059|
|a1a375cc-b6c0-29b2-485a-330af7447564|C:UsersDownl...|/testDB/6|pt1|2|100518|\[2059\]|pt1\_2\_2059|
|b04b4c04-6d43-0d8d-4000-6ae88e349eda|C:UsersDownl...|/testDB/3|pt1|2|99919|\[2059\]|pt1\_2\_2059|
|b20df3a7-678b-1cbe-400d-d8e566706682|C:UsersDownl...|/testDB/7|pt1|2|100046|\[2059\]|pt1\_2\_2059|

