# getTablet {#gettablet}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getTablet(table, partition)`

## Arguments {#arguments}

**table** is an in-memory partitioned table.

**partition** is a scalar/vector indicating a partition or partitions. If an element of *partition* belongs to the partitioning scheme of a partition, it represents the entire partition.

## Details {#details}

Return a table or a list of tables corresponding to the specified partition or partitions.

-   If partition is a scalar, return a table.
-   If partition is a vertor, return a tuple in which every element is a table.

## Examples {#examples}

```
db=database(partitionType=RANGE, partitionScheme=2012.06.01 2012.06.10 2012.06.20 2012.07.01)
n=30
t=table(take(2012.06.01..2012.06.30, n) as date, n..1 as val)
pt=db.createPartitionedTable(table=t, tableName=`pt, partitionColumns=`date).append!(t);

getTablet(pt, 2012.06.05);
```

|date|val|
|----|---|
|2012.06.01|30|
|2012.06.02|29|
|2012.06.03|28|
|2012.06.04|27|
|2012.06.05|26|
|2012.06.06|25|
|2012.06.07|24|
|2012.06.08|23|
|2012.06.09|22|

```
result=getTablet(pt, 2012.06.22 2012.06.11);
result.size();
// output: 2

result[0];
```

|date|val|
|----|---|
|2012.06.20|11|
|2012.06.21|10|
|2012.06.22|9|
|2012.06.23|8|
|2012.06.24|7|
|2012.06.25|6|
|2012.06.26|5|
|2012.06.27|4|
|2012.06.28|3|
|2012.06.29|2|
|2012.06.30|1|

