# getTablesByCluster {#getTablesByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getTablesByCluster(clusterName, dbUrl)`

## Arguments {#arguments}

**clusterName** is a STRING scalar indicating the name of the cluster.

**dbUrl** is a STRING scalar indicating the path of the database.

## Details {#details}

Return all tables in the specified database of the specified cluster. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A STRING vector.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
// MoMSender cluster: 
db = database(directory="dfs://db1", partitionType=RANGE, partitionScheme=0 5 10)
timestamp = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12]
sym = `C`MS`MS`MS`IBM`IBM`C`C`C
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800
t = table(timestamp, sym, qty, price);
dt=db.createDimensionTable(t,`dt).append!(t);
   
// MoM cluster: 
getTablesByCluster("MoMSender", "dfs://db1")
// Output:  ["dt"]
```

