# getTSDBSortKeyEntry {#gettsdbsortkeyentry}

## Syntax {#section_ccd_4bb_dzb .section}

`getTSDBSortKeyEntry(chunkId, [tableName])`

## Arguments {#section_o3c_pbb_dzb .section}

**chunkId** is a STRING scalar or vector indicating the chunk ID. Note: When *chunkId* is a vector, its length cannot exceed 1024.

**tableName** \(optional\) is a STRING scalar indicating the DFS table name. If not specified, all tables under the specified chunk are checked.

## Details {#section_sls_pbb_dzb .section}

This function obtains information on the sort key entries of each chunk \(See the parameter [sortColumns](../c/createPartitionedTable.md)\). It returns a table containing the following information:

-   chunkId: The chunk ID.

-   chunkPath: The DFS path to the chunk.

-   tableName: The DFS table name.

-   file: The level file name.

-   key: The sort key entry. Use an underscore "\_" to separate sort keys.

-   size: The number of records with the sort key entry.


Note that the function cannot check data in the cache engine. You can call [flushTSDBCache](../f/flushTSDBCache.md) to forcibly flush the completed transactions cached in the TSDB cache engine to disk.

## Examples {#section_fq1_sbb_dzb .section}

``` {#codeblock_nm1_tbb_dzb}
n = 10000
SecurityID = rand(`st0001`st0002`st0003`st0004`st0005, n)
sym = rand(`A`B`C`D`E, n)
TradeDate = 2022.01.01 + rand(100,n)
TotalVolumeTrade = rand(1000..3000, n)
TotalValueTrade = rand(100.0, n)
schemaTable_snap = table(SecurityID, sym, TradeDate, TotalVolumeTrade, TotalValueTrade).sortBy!(`SecurityID`sym`TradeDate)

dbPath = "dfs://TSDB_STOCK"
if(existsDatabase(dbPath)){dropDatabase(dbPath)}
db_snap = database(dbPath, VALUE, 2022.01.01..2022.01.05, engine='TSDB')

snap=createPartitionedTable(dbHandle=db_snap, table=schemaTable_snap, tableName="snap", partitionColumns=`TradeDate, sortColumns=`SecurityID`sym`TradeDate, keepDuplicates=ALL, sortKeyMappingFunction=[hashBucket{,3}, hashBucket{,2}])
snap.append!(schemaTable_snap)

snap1=createPartitionedTable(dbHandle=db_snap, table=schemaTable_snap, tableName="snap1", partitionColumns=`TradeDate, sortColumns=`SecurityID`sym`TradeDate, keepDuplicates=ALL)
snap1.append!(schemaTable_snap)

flushTSDBCache()
```

``` {#codeblock_om1_tbb_dzb}
getChunksMeta()
```

|site|chunkId|path|dfsPath|type|flag|size|version|state|versionList|resolved|
|----|-------|----|-------|----|----|----|-------|-----|-----------|--------|
|server11352|fe93077a-5a05-34a8-554c-67467415bf68|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220410/yv|/TSDB\_STOCK/20220410/yv|1|0|0|1|0|cid : 2134,snap1=&gt;2134:89; \#|false|
|server11352|5c30ef71-3e51-c5ac-6b4d-4458feb8454a|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220407/yv|/TSDB\_STOCK/20220407/yv|1|0|0|1|0|cid : 2134,snap1=&gt;2134:95; \#|false|
|server11352|4216dbe9-c238-49a9-4d45-66829c98a7b5|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220406/yv|/TSDB\_STOCK/20220406/yv|1|0|0|1|0|cid : 2134,snap1=&gt;2134:92; \#|false|
|server11352|47ea0d35-7ea9-c3b3-cc4b-cc6cd1fe039d|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220401/yv|/TSDB\_STOCK/20220401/yv|1|0|0|1|0|cid : 2134,snap1=&gt;2134:100; \#|false|
|server11352|aafd71c5-a197-63a9-2d4c-b65cbced3d21|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220330/yv|/TSDB\_STOCK/20220330/yv|1|0|0|1|0|cid : 2134,snap1=&gt;2134:97; \#|false|

``` {#codeblock_nj5_5bb_dzb}
getTSDBSortKeyEntry("fe93077a-5a05-34a8-554c-67467415bf68")
```

|chunkId|chunkPath|tableName|file|key|size|
|-------|---------|---------|----|---|----|
|fe93077a-5a05-34a8-554c-67467415bf68|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220410/yv|snap1|0\_00000058|st0001\_A|2|
|fe93077a-5a05-34a8-554c-67467415bf68|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220410/yv|snap1|0\_00000058|st0001\_B|3|
|fe93077a-5a05-34a8-554c-67467415bf68|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220410/yv|snap1|0\_00000058|st0001\_C|2|
|fe93077a-5a05-34a8-554c-67467415bf68|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220410/yv|snap1|0\_00000058|st0001\_D|6|
|fe93077a-5a05-34a8-554c-67467415bf68|/dolphindb/server/server11352/storage/CHUNKS/TSDB\_STOCK/20220410/yv|snap1|0\_00000058|st0002\_A|4|

**Parent topic:**[Functions](../../Functions/category.md)

