# getTSDBDataStat {#gettsdbdatastat}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getTSDBDataStat([dbName="*"], [tableName="*"], [chunkId])`

## Arguments {#arguments}

**dbName** \(optional\) is a string indicating the database name. It can contain wildcards \("\*", "%", and "?"\). The default value is "\*".

**tableName** \(optional\) is a string indicating the table name. It can contain wildcards \("\*", "%", and "?"\). The default value is "\*".

**chunkId** \(optional\) is a STRING scalar or vector indicating chunk ID\(s\). If *chunkId* is specified, *dbName* and *tableName* must be empty or “\*”.

"\*" matches all; "?" matches a single character; "%" matches 0, 1 or more characters.

## Details {#details}

Get the number of level files and sort key entries of specified chunks on the current node. You can also use function `pnodeRun` to check the number of level files and sort key entries of tables in a cluster.

**Return value**: A table containing the following columns:

-   levelFileCount: the number of level files of tables for each chunk.

-   sortKeyEntryCount: the number of sort key entries that has not been deduplicated in all level files for each chunk.


## Examples {#examples}

```python
t = table(1 2 1 1 2 2 3 as month, `Rome`Paris`London`Paris`Rome`London`Rome as city, 200 500 100 300 300 400 400 as sold)
db_name = "dfs://window_function"
if (existsDatabase(db_name)) {
    dropDatabase(db_name)
}
db = database(db_name, HASH, [INT, 4], , 'TSDB')

pt = db.createPartitionedTable(t, "pt", "month", ,"sold")
pt.append!(t)

pt1 = db.createPartitionedTable(t, "pt1", "month", ,"sold")
pt1.append!(t)
```

Get the number of level files and sort key entries for all tables in the databases starting with *dfs://window*.

```python
getTSDBDataStat("dfs://window%")  
/* outputdbName                chunkId                              tableName levelFileCount sortKeyEntryCount
--------------------- ------------------------------------ --------- -------------- -----------------
dfs://window_function 520e78eb-49b9-93a8-4c28-7f367007aa14 pt        1              3                
dfs://window_function 4859462b-62e7-9782-42f1-5c32a7109782 pt1       1              3                
dfs://window_function 9bcc10db-ffe7-4994-4ac7-f37a8cb69c65 pt        1              3                
dfs://window_function 1d2b7a5e-6da9-2d9f-4eff-e0e60e49e785 pt1       1              3                
dfs://window_function 4ca5d901-6d86-2db8-40eb-ee1d63184b99 pt        1              1                
dfs://window_function c7da5329-569d-4888-4ed4-746a28b09079 pt1       1              1           
*/
```

Get the number of level files and sort key entries for table "pt" in the databases starting with *dfs://window*.

```python
getTSDBDataStat("dfs://window%","pt") 
/* output
dbName                chunkId                              tableName levelFileCount sortKeyEntryCount
--------------------- ------------------------------------ --------- -------------- -----------------
dfs://window_function 520e78eb-49b9-93a8-4c28-7f367007aa14 pt        1              3                
dfs://window_function 9bcc10db-ffe7-4994-4ac7-f37a8cb69c65 pt        1              3                
dfs://window_function 4ca5d901-6d86-2db8-40eb-ee1d63184b99 pt        1              1       
*/
```

Get the number of level files and sort key entries for specified chunk:

``` {#codeblock_nxb_tsh_fdc}
getTSDBDataStat(chunkId="520e78eb-49b9-93a8-4c28-7f367007aa14")
```

|dbName|chunkId|tableName|levelFileCount|sortKeyEntryCount|
|------|-------|---------|--------------|-----------------|
|dfs://window\_function|520e78eb-49b9-93a8-4c28-7f367007aa14|pt|1|3|

