# getSubscriptionTopic {#getsubscriptiontopic}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getSubscriptionTopic(tableName, [actionName])`

## Arguments {#arguments}

**tableName** is a string indicating the name of the shared stream table.

**actionName** \(optional\) is a string indicating the name of the subscription task. It can use letters, digits and underscore.

## Details {#details}

Return a tuple with 2 elements: the subscription topic name and a list of column names of the stream table. It can only be executed on a publisher node.

The subscription topic name is a combination of the information about the node that the stream table is located \(the intranet IP address, port number and node alias separated by ":"\), the stream table name, and the subscription task name \(if actionName is specified\) separated by "/". For example, if the intranet IP of the server is "localhost:8848:nodeA" and the stream table name is "trades", the topic is "localhost:8848:nodeA/trades"; If the subscription task name is "vwap", then the topic is "localhost:8848:nodeA/trades/vwap".

## Examples {#examples}

The following script is executed on a node with alias "rh8502":

```
t=streamTable(1000000:0,`date`time`sym`qty`price`exch,[DATE,TIME,SYMBOL,INT,DOUBLE,SYMBOL])
share t as trades
trades_1=streamTable(1000000:0,`date`time`sym`qty`price`exch,[DATE,TIME,SYMBOL,INT,DOUBLE,SYMBOL])
subscribeTable(tableName=`trades, actionName=`vwap, offset=-1, handler=append!{trades_1})
getSubscriptionTopic(`trades,`vwap);
// output: ("192.168.1.135:8502/rh8502/trades/vwap",["date","time","sym","qty","price","exch"])
```

