# getStreamTableCacheOffset {#getStreamTableCacheOffset}

## Syntax {#Syntax.1 .section}

`getStreamTableCacheOffset(streamTable)`

## Arguments {#Arguments.1 .section}

**streamTable** is a non-persisted stream table that has cache purge enabled \(with either `enableTableShareAndCachePurge` or `enableTableCachePurge`\).

## Details {#Details.1 .section}

Check number of records that have been purged from cache by calculating the difference between the number of records retained in memory and the number of records written to the table.

## Examples {#section_tyn_1tw_bdc .section}

``` {#codeblock_vfx_btw_bdc}
t = streamTable(1000:0, `time`sym`volume, [DATETIME, SYMBOL, INT])
enableTableShareAndCachePurge(table=t, tableName=`st, cachePurgeTimeColumn=`time,
 cachePurgeInterval=30m, cacheRetentionTime=20m)

time = datetime(2024.01.01T09:00:00) +1..1000*2
sym=take(`a`b`c, 1000)
volume = rand(10,1000)

insert into t values([time, sym, volume])
getStreamTableCacheOffset(t)
// output: 0

time = datetime(2024.01.01T09:35:00) +1..1000*2
sym=take(`a`b`c, 1000)
volume = rand(10,1000)
insert into t values([time, sym, volume])
getStreamTableCacheOffset(t)
//output: 999
```

**Parent topic:**[Functions](../../Functions/category.md)

