# getStreamGraphMeta {#getStreamGraphMeta}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getStreamGraphMeta([name])`

## Arguments {#arguments}

**name** \(optional\) is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Return the metadata of the specified streaming graph.

If *name* is not specified, the function returns the metadata of all streaming graphs.

**Return value:** a table containing the following fields:

-   **id:** Streaming graph ID.
-   **fqn:** Fully qualified name of the streaming graph.
-   **status:** Running status of the streaming graph:
    -   **building:** Graph has been scheduled and is under construction.
    -   **running:** Graph construction completed and running normally.
    -   **error:** Recoverable fault encountered \(e.g., node OOM\); the system will reschedule the tasks.
    -   **failed:** Unrecoverable fault encountered \(e.g., user script error\); the system will preserve the scene for later analysis.
    -   **destroying:** Graph is being destroyed.
    -   **destroyed:** Graph has been destroyed.
-   **semantics:** Consistency semantics, possible values:
    -   **exactly-once:** Exactly-once execution.
    -   **at-least-once:** At-least-once execution.
-   **checkpointConfig:** Checkpoint-related configuration, which can be modified using the `setCheckpointConfig` interface.
-   **tasks:** Scheduling metadata of the streaming graph, including:
    -   **id:** Task ID.
    -   **node:** Name of the node running the task.
    -   **status:** Execution status of the task.
    -   **reason:** Reason for `error` or `failed`.
-   **createTime:** Creation time.
-   **owner:** Creator of the streaming graph.
-   **reason:**Reason for state transition.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getStreamGraphMeta("streamGraph1") // name is the name of the streaming graph
getStreamGraphMeta("catalog1.orca_graph.streamGraph1") // name is the fully qualified name
```

