# getStreamGraphInfo {#getStreamGraphInfo}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getStreamGraphInfo([name])`

## Arguments {#arguments}

**name** \(optional\) is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Return the metadata of the specified streaming graph.

If *name* is not specified, the function returns the metadata of all streaming graphs.

**Return value:** a table containing the following fields:

-   **id:** Streaming graph ID.
-   **fqn:** Fully qualified name of the streaming graph.
-   **graph:** The structure of the streaming graph in JSON format, including:
    -   **version:** Version number of the graph structure, used to prevent compatibility issues caused by version upgrades.
    -   **nodes:** Nodes in the graph, each containing:
        -   **id:** Node ID.
        -   **subgraphId:** Subgraph ID the node belongs to.
        -   **taskid:** Streaming task ID.
        -   **parallelism:**
            -   **keyName:** The column name used for partitioning parallel tasks.
            -   **count:** Number of parallel tasks.
        -   **properties:** Node properties.
        -   **inEdges:** List of incoming edge IDs.
        -   **outEdges:** List of outgoing edge IDs.
    -   **edges:** Edges in the graph, each containing:
        -   **id:** Edge ID.
        -   **inNodeId:** ID of the upstream node.
        -   **outNodeId:** ID of the downstream node.
        -   **partitionType:**
            -   **FORWARD:** Directly send upstream data to downstream.
            -   **NESTED:** Distribute upstream data to downstream according to the nested relationship of parallelism.
            -   **SHUFFLE:** Recombine upstream data into a single set and distribute to downstream based on parallelism.
        -   **filter:** Filter condition on the edge.
        -   **handlers:** List of functions to process upstream data; these functions will be merged into the `handler` parameter of `subscribeTable`.
    -   **config:** Global configuration of the streaming graph.
-   **meta:** Scheduling metadata of the streaming graph in JSON format, including:
    -   **id:** Streaming graph ID.
    -   **status:** Running status of the streaming graph:
        -   **building:** Graph has been scheduled and is under construction.
        -   **running:** Graph construction completed and running normally.
        -   **error:** Recoverable fault encountered \(e.g., node OOM\); the system will reschedule the tasks.
        -   **failed:** Unrecoverable fault encountered \(e.g., user script error\); the system will preserve the scene for later analysis.
        -   **destroying:** Graph is being destroyed.
        -   **destroyed:** Graph has been destroyed.
    -   **semantics:** Consistency semantics, possible values:
        -   **exactly-once:** Exactly-once execution.
        -   **at-least-once:** At-least-once execution.
    -   **tasks:** Scheduling information of streaming tasks.
    -   **createTime:** Creation time.
    -   **reason:** Reason for state transition.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getStreamGraphInfo("streamGraph1") // name is the name of the streaming graph
getStreamGraphInfo("catalog1.orca_graph.streamGraph1") // name is the fully qualified name
```

