# getStreamEngineStat {#getstreamenginestat}

## Syntax {#syntax}

`getStreamEngineStat()`

Alias: getAggregatorStat

## Arguments {#arguments}

None

## Details {#details}

Return a dictionary of tables with various metrics about all stream engines.

-   Table *TimeSeriesEngine* returns the following columns about time-series engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |windowTime|the length of the data window|
    |step|the duration between 2 adjacent windows|
    |useSystemTime|the value of parameter useSystemTime in function createTimeSeriesEngine|
    |garbageSize|the threshold of the number of records in memory that triggers memory cleaning|
    |numGroups|the number of groups that the stream engine has handled|
    |numRows|the number of records that has entered the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|
    |snapshotDir|the directory to save engine snapshot|
    |snapshotInterval|the interval to save snapshot|
    |snapshotMsgId|the msgId of engine snapshot|
    |snapshotTimestamp|the timestamp of snapshot|

-   Table *CrossSectionalEngine* returns the following columns about cross-sectional engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |numRows|the number of records that has entered the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |triggeringPattern|how calculations are triggered|
    |triggeringInterval|the duration in milliseconds between 2 adjacent calculations|
    |memoryUsed|the amount of memory used|

-   Table *AnomalyDetectionEngine* returns the following columns about the anomaly detection engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |numGroups|the number of groups that the stream engine has handled|
    |numRows|the number of records that has entered the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |snapshotDir|the directory to save engine snapshot|
    |snapshotInterval|the interval to save snapshot|
    |snapshotMsgId|the msgId of engine snapshot|
    |snapshotTimestamp|the timestamp of snapshot|
    |garbageSize|the threshold of the number of records in memory that triggers memory cleaning|
    |memoryUsed|the amount of memory used|

-   Table *ReactiveStateEngine* returns the following columns about the reactive state engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the reactive state engine|
    |metrics|the metacode specifying the formulas for calculation|
    |dummyTable|a table object whose schema must be the same as the subscribed stream table|
    |outputTable|the output table for the results|
    |keyColumn|the grouping column\(s\)|
    |filter|the metacode indicating the filtering conditions in the form of expression|
    |snapshotDir|the number of metrics calculated by the stream engine|
    |snapshotIntervalInMsgCount|the number of messages to receive before the next snapshot is saved|
    |keepOrder|whether to preserve the insertion order of the records in the output table|
    |keyPurgeFilter|the filtering conditions that identify the data to be purged from the cache|
    |keyPurgeFreqInSecond|the time interval \(in seconds\) to trigger a purge|
    |raftGroup|the ID of the raft group on the high-availability streaming subscriber specified by the configuration parameter *streamingRaftGroups*|
    |outputElapsedMicroseconds|whether to output the elapsed time \(in microseconds\) from the ingestion of data to the output of result in each batch and the total number of each batch|

-   Table *SessionWindowEngine* returns the following columns about the session window engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |sessionGap|gap between 2 session windows|
    |useSystemTime|whether the stream engine is triggered as soon as data are ingested into the system|
    |numGroups|the number of groups that the stream engine has handled|
    |numRows|the number of records that has entered the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |Metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|
    |snapshotDir|the directory to save snapshot|
    |snapshotInterval|the interval to save snapshot|
    |snapshotMsgId|the message ID \(msgId\) of engine snapshot|
    |snapshotTimestamp|the timestamp of snapshot|

-   Table *DailyTimeSeriesEngine* returns the following columns about the daily time series engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |windowTime|the length of the window|
    |step|the duration between 2 adjacent windows|
    |useSystemTime|the value of parameter useSystemTime in function createDailyTimeSeriesEngine|
    |garbageSize|the threshold of the number of records in memory that triggers memory cleaning|
    |numGroups|the number of groups that the stream engine has handled|
    |numRows|the number of records that has entered the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|
    |snapshotDir|the directory to save snapshot|
    |snapshotInterval|the interval to save snapshot|
    |snapshotMsgId|the message ID \(msgId\) of engine snapshot|
    |snapshotTimestamp|the timestamp of snapshot|

-   Table *AsofJoinEngine* returns the following columns about the as of join engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |useSystemTime|the value of parameter useSystemTime in function createAsofJoinEngine|
    |delayedTime|the value of parameter delayedTime in function createAsofJoinEngine|
    |garbageSize|the threshold of the number of records in memory that triggers memory cleaning|
    |leftTableNumRows|the number of records in the left table of stream engine|
    |rightTableNumRows|the number of records in the right table of stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|

-   Table *EquiJoinEngine* returns the following columns about the equi join engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |garbageSize|whether the stream engine is triggered as soon as data are ingested into the system|
    |leftTableNumRows|the number of records that has entered the left table of the stream engine|
    |rightTableNumRows|the number of records that has entered the right table of the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|

-   Table *WindowJoinEngine* returns the following columns about the window join engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |garbageSize|whether the stream engine is triggered as soon as data are ingested into the system|
    |leftTableNumRows|the number of records that has entered the left table of the stream engine|
    |rightTableNumRows|the number of records that has entered the right table of the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|
    |numGroups|the number of groups|

-   Table *LookupJoinEngine* returns the following columns about the lookup join engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |garbageSize|whether the stream engine is triggered as soon as data are ingested into the system|
    |leftTableNumRows|the number of records that has entered the left table of the stream engine|
    |rightTableNumRows|the number of records that has entered the right table of the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|

-   Table *LeftSemiJoinEngine* returns the following columns about the left semi join engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |garbageSize|whether the stream engine is triggered as soon as data are ingested into the system|
    |leftTableNumRows|the number of records that has entered the left table of the stream engine|
    |rightTableNumRows|the number of records that has entered the right table of the stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|

-   Table *SnapshotJoinEngine* returns the following columns about snapshot join engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |leftTableNumRows|the number of records in the left table of stream engine|
    |rightTableNumRows|the number of records in the right table of stream engine|
    |numMetrics|the number of metrics calculated by the stream engine|
    |metrics|the metacode of the metrics calculated by the stream engine|
    |memoryUsed|the amount of memory used|

-   Table *DualOwnershipReactiveStateEngine* returns the following columns about the dual ownership reactive state engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the engine|
    |metrics|the metacode specifying the formulas for calculation|
    |dummyTable|a table object whose schema must be the same as the subscribed stream table|
    |outputTable|the output table for the results|
    |keyColumn|the grouping column\(s\)|
    |filter|the metacode indicating the filtering conditions in the form of expression|
    |snapshotDir|the number of metrics calculated by the stream engine|
    |snapshotIntervalInMsgCount|the number of messages to receive before the next snapshot is saved|
    |keepOrder|whether to preserve the insertion order of the records in the output table|
    |keyPurgeFilter|the filtering conditions that identify the data to be purged from the cache|
    |keyPurgeFreqInSecond|the time interval \(in seconds\) to trigger a purge|
    |raftGroup|the ID of the raft group on the high-availability streaming subscriber specified by the configuration parameter *streamingRaftGroups*|
    |outputElapsedMicroseconds|whether to output the elapsed time \(in microseconds\) from the ingestion of data to the output of result in each batch and the total number of each batch|

-   Table *NarrowReactiveStateEngine* returns the following columns about the narrow reactive state engine:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the engine|
    |metrics|metacode or a tuple of metacode containing columns from the input table \(excluding *keyColumn*, optional\) or factors \(formulas for calculation, required\)|
    |metricNames|the name for each factor specified in *metrics*|
    |dummyTable|a table object whose schema must be the same as the subscribed stream table|
    |outputTable|the output table for the results|
    |keyColumn|the grouping column\(s\)|
    |filter|the metacode indicating the filtering conditions in the form of expression|
    |keepOrder|whether to preserve the insertion order of the records in the output table|
    |keyPurgeFilter|the filtering conditions that identify the data to be purged from the cache|
    |keyPurgeFreqInSecond|the time interval \(in seconds\) to trigger a purge|
    |outputElapsedMicroseconds|whether to output the elapsed time \(in microseconds\) from the ingestion of data to the output of result in each batch and the total number of each batch|

-   Table *StreamFilter* returns the following columns about stream filter:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |numRows|the number of records that has entered the stream engine|
    |filters|the filtering condition|

-   Table *StreamDispatchEngine* returns the following columns about stream dispatch engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the stream engine|
    |user|name of the user who created the stream engine|
    |status|status of the stream engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |numRows|the number of records that has entered the stream engine|
    |memoryUsed|the amount of memory used|

-   Table *TimeBucketEngine* returns the following columns about time bucket engines:

    |Column Name|Description|
    |-----------|-----------|
    |name|name of the time bucket engine|
    |user|name of the user who created the time bucket engine|
    |status|status of the time bucket engine. "OK" means available; "FATAL" means unavailable|
    |lastErrMsg|the latest error message|
    |numGroups|the number of groups that the time bucket engine has handled|
    |numRows|the number of records that has entered the time bucket engine|
    |numMetrics|the number of metrics calculated by the time bucket engine|
    |metrics|the metacode of the metrics calculated by the time bucket engine|
    |memoryUsed|the amount of memory used|


## Examples {#examples}

```
share streamTable(10:0,`time`sym`price`qty,[TIMESTAMP,SYMBOL,DOUBLE,INT]) as trades
outputTable1 = table(10000:0, `time`sym`sumQty, [TIMESTAMP, SYMBOL, INT])
outputTable2 = table(1:0, `time`avgPrice`sumqty`Total, [TIMESTAMP,DOUBLE,INT,DOUBLE])
tradesTsEngine = createTimeSeriesEngine(name="TimeSeriesDemo", windowSize=3, step=3, metrics=<[sum(qty)]>, dummyTable=trades, outputTable=outputTable1, timeColumn=`time, keyColumn=`sym, garbageSize=50)
tradesCsEngine=createCrossSectionalEngine(name="CrossSectionalDemo", metrics=<[avg(price), sum(qty), sum(price*qty)]>, dummyTable=trades, outputTable=outputTable2, keyColumn=`sym, triggeringPattern=`perRow)
subscribeTable(tableName="trades", actionName="tradesTsEngine", offset=0, handler=append!{tradesTsEngine}, msgAsTable=true)
subscribeTable(tableName="trades", actionName="tradesCsEngine", offset=0, handler=append!{tradesCsEngine}, msgAsTable=true)

def writeData(n){
   timev = 2000.10.08T01:01:01.001 + timestamp(1..n)
   symv =take(`A`B, n)
   pricev=take(102.1 33.4 73.6 223,n)
   qtyv = take(60 74 82 59, n)
   insert into trades values(timev, symv, pricev,qtyv)
}

writeData(4);

getStreamEngineStat().TimeSeriesEngine;
getStreamEngineStat().CrossSectionalEngine;
```

