# getSlaveReplicationQueueStatus {#getclusterreplicationmetrics}

## Syntax {#section_x2r_3x1_dzb .section}

`getSlaveReplicationQueueStatus()`

## Arguments {#section_q2t_jx1_dzb .section}

None

## Details {#section_oc3_kx1_dzb .section}

The function obtains the status of each execution queue in the slave cluster of asynchronous replication, and returns a table containing the following columns:

-   executionSet: the execution set ID to which the task belongs.

-   queueId: ID of the execution queue to which the replication task belongs.

-   unfinishedTasks: the number of unfinished tasks in the queue.

-   executionGroupId: ID of the group to which the running replication task belongs.

-   executionNode: the data node where the task is executed.

-   executionTime: the time spent by the current group executing replication tasks.

-   status: the task status, including EXECUTING, FINISHED, STOPPED and FAILED.


## Examples {#section_kwc_lx1_dzb .section}

``` {#codeblock_ncd_mx1_dzb}
getSlaveReplicationQueueStatus()
```

|queueId|unfinishedTasks|executionGroupId|executionNode|executionTime|status|
|:------|:--------------|:---------------|:------------|:------------|:-----|
|0|0|-1|dnode1|00:00:00.000|FINISHED|
|1|0|-1|dnode2|00:00:00.000|FINISHED|

Related functions: [getSlaveReplicationStatus](getSlaveReplicationStatus.md), [getMasterReplicationStatus](getMasterReplicationStatus.md)

**Parent topic:**[Functions](../../Functions/category.md)

