# getScheduledJobs {#getscheduledjobs}

## Syntax {#syntax}

`getScheduledJobs([jobIdPattern])`

## Arguments {#arguments}

**jobIdPattern** is a string indicating a job ID or a pattern of job ID. It supports wildcard characters \(% and ?\).

## Details {#details}

Return a table of scheduled jobs. If *jobIdPattern* is not specified, return all scheduled jobs.

It returns a table with the following columns:

|Name|Meaning|
|----|-------|
|userId|the user ID|
|jobId|the job ID|
|jobDesc|the job description|
|startDate|the start date of the scheduled job \(of DATE type\)|
|endDate|the end date of the scheduled job \(of DATE type\)|
|frequency|the frequency to execute the scheduled job|
|scheduledTime|the specified time to execute each job \(of MINUTE type\)|
|days|the specified days to execute the scheduled job when *frequency* is 'W' or 'M'.|

## Examples {#examples}

```
getScheduledJobs();
```

|userId|jobId|jobDesc|startDate|endDate|frequency|scheduleTime|days|
|------|-----|-------|---------|-------|---------|------------|----|
|root|monthly|Monthly Job|2018.01.01|2018.12.31|M|17:00m|1|
|root|weekly|Weekly Job|2018.01.01|2018.12.31|W|17:30m|2|
|root|daily|Daily Job|2018.01.01|2018.12.31|D|18:00m||

