# getRecoveryTaskStatus {#getrecoverytaskstatus}

## Syntax {#syntax}

`getRecoveryTaskStatus()`

## Arguments {#arguments}

None

## Details {#details}

Get the status of recovery tasks. This function can only be executed on a controller.

Return a table containing the following columns:

-   TaskId: The job ID of the recovery task.

-   TaskType: The type of the recovery task. It can be "LoadRebalance" and "ChunkRecovery".

-   ChunkId: The chunk ID.

-   ChunkPath: The DFS path of the chunk.

-   Source: The source node for data recovery.

-   Dest: The destination node for data recovery.

-   Status: The status of the recovery task. It can be "Waiting", "In-Progress", and "Finished" or "Aborted".

-   AttemptCount: The number of recovery attempts that have been made.

-   DeleteSource: Whether to delete the replica on the source node. When *TaskType* is "ChunkRecovery", it is false. When *TaskType* is "LoadRebalance", it can be true or false.

-   StartTime: The time when the recovery task is created.

-   LastDequeueTime: The last time when the recovery task is dequeued.

-   LastStartTime: The last time when the recovery task started.

-   FinishTime: The time when the recovery task was finished.

-   IsIncrementalRecovery: Whether incremental replication is enabled.

-   IsAsyncRecovery: Whether asynchronous replication is enabled.

-   ChangeFromIncrementalToFull: Whether incremental replication has been changed to full replication. The recovery will be automatically changed to full recovery after multiple attempts for incremental recovery fail.

-   ChangeToSyncTime: The time when the online recovery is changed from asynchronous to synchronous.

-   FailureReason: The reason for the failure of the recovery tasks.


## Examples {#examples}

```
getRecoveryTaskStatus();
```

