# getRecentJobs {#getrecentjobs}

## Syntax {#syntax}

`getRecentJobs(n)`

## Arguments {#arguments}

**n** is a positive integer. If it is unspecified, return all batch jobs since the session is started.

## Details {#details}

Retrieve the status of most recent n batch jobs on the local node.

It returns a table with the following columns:

|Name|Meaning|
|----|-------|
|node|the alias of the local node|
|userID|the user ID|
|jobId|the job ID|
|rootJobId|the root job ID|
|jobDesc|the job description|
|priority|priority of the job which is marked as integers ranging from 0 to 9|
|parallelism|the parallelism, i.e., the maximum number of jobs that can run in parallel|
|clientIp|the IP address of the client where the job is submitted|
|clientPort|the port number of the client where the job is submitted|
|receivedTime|the time \(of TIMESTAMP type\) when a job is received by the node|
|startTime|the start time of jobs \(of TIMESTAMP type\)|
|endTime|the end time of jobs \(of TIMESTAMP type\)|
|errorMessage|error messages|

For details please refer to [Batch Job Management](../../Maintenance/BatchJobManagement.md).

## Examples {#examples}

```
def jobDemo(n){
   s = 0
   for (x in 1 : n) {
       s += sum(sin rand(1.0, 100000000)-0.5)
       print("iteration " + x + " " + s)
   }
   return s
};

submitJob("jobDemo1","job demo", jobDemo, 100);
submitJob("jobDemo2",, jobDemo, 10);
getRecentJobs(10);
```

|node|userID|jobId|jobDesc|priority|parallelism|receivedTime|startTime|...|
|----|------|-----|-------|--------|-----------|------------|---------|---|
|local8848|guest|jobDemo1|job demo|0|1|2021.04.28T14:20:24.879|2021.04.28T14:20:24.886|...|
|local8848|guest|jobDemo2|jobDemo|0|1|2021.04.28T14:20:24.886|2021.04.28T14:20:24.886|...|

