# getReactiveMetrics {#getreactivemetrics}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getReactiveMetrics(name)`

## Arguments {#arguments}

**name**is a string indicating the engine name.

## Details {#details}

Get factors specified in *metric*s of the engine generated by `createNarrowReactiveStateEngine`.

It returns a table cotaining two columns:

-   metricName: the name of factors.

-   metricCode: the detailed formula for calculations.


## Examples {#examples}

``` {#codeblock_pys_vvq_g1c}
dummy = streamTable(1:0, ["securityID1","securityID2","securityID3","createTime","updateTime","upToDatePrice","qty","value"], [STRING,STRING,STRING,TIMESTAMP,TIMESTAMP,DOUBLE,DOUBLE,INT]) 
outputTable = streamTable(1:0,["securityID1","securityID2","securityID3","createTime","updateTime","metricNames","factorValue"], [STRING,STRING,STRING, TIMESTAMP,TIMESTAMP,STRING,DOUBLE])
factor = [<createTime>, <updateTime>,<cumsum(qty)>]
Narrowtest = createNarrowReactiveStateEngine(name="narrowtest1",metrics=factor,metricNames="factor1",dummyTable=dummy,outputTable=outputTable,keyColumn=["securityID1","securityID2","securityID3"])
getReactiveMetrics("narrowtest1")

metricName	metricCode
factor1     cumsum(qty)
```

Related functions: [createNarrowReactiveStateEngine](../c/createNarrowReactiveStateEngine.md),[addReactiveMetrics](../a/addReactiveMetrics.md)

