# getRaftLearnersStatus {#getRaftLearnersStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getRaftLearnersStatus(groupId)`

## Arguments {#arguments}

**groupId** is an integer greater than 1 indicating raft group ID.

## Details {#details}

Retrieve the status of all Learner nodes in a specified Raft group.

**Return value:** A table with the following columns:

-   nameName: The node name.
-   nodeId: The node ID.
-   matchIndex: The highest log entry index that the Leader has confirmed as replicated to the Learner.
-   nextIndex: The index of the next log entry the Leader will send to the Learner.
-   replicationLag: The number of log entries delayed in replication. A smaller value indicates lower latency.
-   lastActiveTime: The timestamp of the most recent successful communication between the Leader and the Learner.
-   snapshotProgress: Snapshot transfer progress. 0 indicates that no snapshot transfer is currently in progress.

## Examples {#examples}

``` {#codeblock_hgp_xgp_mgc}
getRaftLearnersStatus(3)
```

|nodeName|nodeId|matchIndex|nextIndex|replicationLag|lastActiveTime|snapshotProgress|
|--------|------|----------|---------|--------------|--------------|----------------|
|datanode8922@cluster2|256|10,004|10,005|0|2025.08.18 14:00:15.349|0|

