# getPKEYCompactionTaskStatus {#getPKEYCompactionTaskStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getPKEYCompactionTaskStatus([count])`

## Arguments {#arguments}

**count** \(optional\) is a non-negative integer that specifies how many recent completed compaction tasks \(successful or failed\) to report per volume. The default value is 0, indicating that all completed compaction tasks are returned.

## Details {#details}

Obtain the status of PKEY level file compaction tasks, including all pending tasks and completed tasks.The optional *count* limits the number of completed tasks returned. The function can only be executed on a data node.

**Return value**: A table with the following columns:

-   volume: the volume where the compaction is performed. It is set by the configuration parameter *volumes*.
-   level: the level of files that are involved in the current compaction. An empty cell means the compaction hasn’t started, is ongoing, or failed.A compaction involves up to two levels at a time.
-   chunkId: the ID of chunk where the compaction is performed.
-   tableName: the physical name of the table where the compaction is performed.
-   files: the level files involved in the current compaction. An empty cell means the compaction hasn’t started, is ongoing, or failed.
-   force: whether the compaction is triggered by `triggerPKEYCompaction`.
-   receivedTime: the timestamp when the compaction task enqueued.
-   startTime: the timestamp when the compaction task started.
-   endTime: the timestamp when the compaction task ended.
-   errorMessage: If a task failed, the column displays the failure cause; otherwise it is left empty.

## Examples {#examples}

``` {#codeblock_m4t_fms_cdc}
getPKEYCompactionTaskStatus()
```

|volume|level|chunkId|tableName|files|force|receivedTime|startTime|endTime|errorMessage|
|------|-----|-------|---------|-----|-----|------------|---------|-------|------------|
|/home/dolphindb/server/local8848/storage|2|ac872f06-abed-339c-8642-ce7dcf415691|pt1\_2|2-000000046-002|true|2024.09.24 13:52:37.746|2024.09.24 13:52:37.746|2024.09.24 13:52:37.816||
|/home/dolphindb/server/local8848/storage|1|ac872f06-abed-339c-8642-ce7dcf415691|pt1\_2|1-000000046-001|true|2024.09.24 13:52:32.431|2024.09.24 13:52:32.431|2024.09.24 13:52:32.437||
|/home/dolphindb/server/local8848/storage|0|ac872f06-abed-339c-8642-ce7dcf415691|pt1\_2|0-000000046-000|true|2024.09.24 11:58:42.006|2024.09.24 11:58:42.006|2024.09.24 11:58:42.011||
|/home/dolphindb/server/local8848/storage|0|62ab7ebb-03f2-10a5-5445-c537512aee06|pt1\_2|0-000000045-000|true|2024.09.24 11:57:13.596|2024.09.24 11:57:13.596|2024.09.24 11:57:13.601||

