# getOrcaStreamTaskSubscriptionMeta {#getOrcaStreamTaskSubscriptionMeta}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaStreamTaskSubscriptionMeta(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Retrieve the subscription information of all streaming tasks in the specified streaming graph.

**Return value:** a table containing the following fields:

-   **taskId:** Streaming task ID.
-   **tableName:** Name of the streaming table.
-   **actionName:** Name of the subscription task.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getOrcaStreamTaskSubscriptionMeta("streamGraph1") // name is the name of the streaming graph
getOrcaStreamTaskSubscriptionMeta("catalog1.orca_graph.streamGraph1") // name is the fully qualified name
```

