# getOrcaStreamTableMeta {#getOrcaStreamTableMeta}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaStreamTableMeta([name])`

## Arguments {#arguments}

**name** \(optional\) is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Return the metadata of the specified streaming table in Orca.

If *name* is not specified, the function returns the metadata of all streaming tables in Orca.

**Return value:** a table containing the following fields:

-   **id:** Streaming table ID.
-   **fqn:** Fully qualified name of the streaming table.
-   **site:** Name of the node where the streaming table resides.
-   **graphRefs:** List of streaming graph IDs that reference this streaming table.
-   **raftGroupId:** Raft group ID of the high-availability streaming table; returns 0 for non-HA streaming tables.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getOrcaStreamTableMeta("trade1") // name is the name of the streaming table
getOrcaStreamTableMeta("catalog1.orca_table.trade1") // name is the fully qualified name
```

