# getOrcaStreamEngineMeta {#getOrcaStreamEngineMeta}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaStreamEngineMeta(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Retrieve the metadata of all streaming engines in the specified streaming graph.

**Return value:** a table containing the following fields:

-   **taskId:** ID of the task that owns the engine.
-   **name:** Name of the engine.
-   **type:** Type of the engine.
-   **schema:** Field types of the engine's output table.
-   **fqn:** Fully qualified name defined by `setEngineName`.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getOrcaStreamEngineMeta("streamGraph1") // name is the name of the streaming graph
getOrcaStreamEngineMeta("catalog1.orca_graph.streamGraph1") // name is the fully qualified name
```

