# getMasterReplicationStatus {#getmasterreplicationstatus}

## Syntax {#syntax .section}

`getMasterReplicationStatus([limit=-1])`

## Arguments {#section_udk_vy1_dzb .section}

**limit** \(optional\) is an integer that specifies the maximum tasks that can be returned in the result. The default value is -1, meaning no limit is placed.

## Details {#section_c4x_vy1_dzb .section}

This function displays the cluster replication task status in the master cluster. It returns a table where finished tasks are listed first, then followed by unfinished tasks.

-   If *limit* is not specified, there is no limit on the number of tasks returned.

-   If *limit* is specified, up to *limit* records \(including finished and unfinished tasks\) can be returned.


A maximum of 10,000 records of finished tasks are returned, and the unfinished tasks are displayed from the earliest time until the specified number of records is met.

It can only be executed by an administrator on the controller of a master cluster.

It returns a table containing the following columns:

-   taskId: ID of replication task.

-   tid: transaction ID.

-   groupId: ID of the group to which the replication task belongs to.

-   operationType: the operation type.

-   submitTime: task submission time \(of NANOTIMESTAMP type\).

-   dbName: the database name.

-   tableName: the table name.

-   srcIP: IP of the data node where data of write tasks is stored.

-   srcPort: port of the data node where data of write tasks is stored.

-   isTruncated: whether the task has been finished and garbage-collected from the push queue.


## Examples {#section_cj4_xy1_dzb .section}

```python
getMasterReplicationStatus();
```

|taskId|tid|groupId|operationType|submitTime|dbName|tableName|srcIP|srcPort|isTruncated|
|------|---|-------|-------------|----------|------|---------|-----|-------|-----------|
|1|1|1|CREATE\_DB|2022.11.08T10:50:35.442141722|db://test\_dropPartition\_value||127.0.0.1|8002|true|
|2|2|2|CREATE\_PARTITIONED\_TABLE|2022.11.08T10:50:35.447716190|db://test\_dropPartition\_value|pt|127.0.0.1|8002|true|
|3|3|3|APPEND|2022.11.08T10:50:35.584920262|db://test\_dropPartition\_value|pt|127.0.0.1|8002|true|
|4|4|4|DROP\_PARTITION|2022.11.08T10:50:35.632575800||pt|127.0.0.1|8002|false|

Related functions: [getSlaveReplicationStatus](getSlaveReplicationStatus.md)

