# getMarketCalendar {#getmarketcalendar}

## Syntax {#section_mnk_ry1_dzb .section}

`getMarketCalendar(marketName, [startDate], [endDate])`

## Arguments {#section_pkx_ry1_dzb .section}

**marketName** is a STRING scalar, indicating the identifier of the trading calendar, e.g., the Market Identifier Code of an exchange, or a user-defined calendar name. It must exist in the directory specified by configuration parameter *marketHolidayDir*, otherwise an error will be reported.

**startDate** \(optional\) is a scalar of DATE type. If it is not specified, the default value is January 1st of the earliest year in the file named *marketName*.

**endDate** \(optional\) is a scalar of DATE type. If it is not specified, the default value is December 31st of the latest year in the file named *marketName*.

## Details {#section_q4p_sy1_dzb .section}

DolphinDB provides trading calendars of more than 50 exchanges \(with corresponding CSV files stored in *marketHolidayDir*\). This function is used to get the trading calendar in the time interval determined by *startDate* and *endDate*.

## Examples {#section_mgg_ty1_dzb .section}

``` {#codeblock_s4p_ty1_dzb}
addMarketHoliday("CFFEX",2022.01.03 2022.01.05)
getMarketCalendar("CFFEX",2022.01.01, 2022.01.10)
// output: [2022.01.04,2022.01.06,2022.01.07,2022.01.10]
```

Related functions: [addMarketHoliday](../a/addMarketHoliday.md), [updateMarketHoliday](../u/updateMarketHoliday.md)

