# getMCPPrompt {#getMCPPrompt}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getMCPPrompt(name, [args], [published])`

## Arguments {#arguments}

**name** is a STRING scalar indicating the name of the prompt template.

**args** \(optional\) is a dictionary with STRING keys and ANY or STRING values indicating the arguments passed to the prompt template.

**published** \(optional\) is a Boolean indicating whether to call the published version. Defaults to false, meaning to call the unpublished version.

## Details {#details}

Call the specified MCP prompt template.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
// define a prompt template
addMCPPrompt(
  name = "stock_summary",
  message = "Summary the trend of ${stock} from ${startDate} to ${endDate}.",
  description = "Generate a natural-language overview of a stock over a time period",
  extraInfo = {title : "Stock Trend Summary"}
)
publishMCPPrompts("stock_summary")

// update a prompt template and do not publish it
updateMCPPrompt(
  name = "stock_summary",
  message = "Find the highest and lowest prices of ${stock} from ${startDate} to ${endDate}.",
  description = "description after updating"
)

// call the published stock_summary
getMCPPrompt(name="stock_summary", args={"stock":"000111", "startDate":2025.01.01, "endDate":2025.08.01}, published=true)
// output:Summary the trend of 000111 from 2025.01.01 to 2025.08.01.

// Call the published stock_summary
getMCPPrompt(name="stock_summary", args={"stock":"000111", "startDate":2025.01.01, "endDate":2025.08.01}, published=false)
// output:Find the highest and lowest prices of 000111 from 2025.01.01 to 2025.08.01.
```

