# getJobReturn {#getjobreturn}

## Syntax {#syntax}

`getJobReturn(jobId, [blocking=false])`

## Arguments {#arguments}

**jobId** is a string indicating the batch job ID.

**blocking** \(optional\) is a Boolean value indicating whether the blocking mode is enabled. If *blocking* is false \(default\), the function will return an exception if the job is not completed. If *blocking* is true, the function will not return a value until the job is completed.

## Details {#details}

Retrieve the batch job result. For details about batch jobs please refer to [Batch Job Management](../../Maintenance/BatchJobManagement.md).

## Examples {#examples}

```
def job1(n){
   s = 0
   for (x in 1 : n) {
       s += sum(sin rand(1.0, 100000000)-0.5)
       print("iteration " + x + " " + s)
   }
   return s
}

job1_ID=submitJob("job1_ID","", job1, 100);
getJobReturn(job1_ID);
// output: The job [job1_ID20210428] is not complete yet.
```

Rerun the `getJobReturn` command after the job is completed:

```
getJobReturn(job1_ID);
// output: -13318.181243
```

If we would like `getJobReturn` to hold off returning results until the job is completed, we can set the optional parameter *blocking* to true. This feature is useful in handling batch job dependencies.

```
job1_ID = submitJob("job1_ID","", job1, 100)
getJobReturn(job1_ID, true);
// output: -31900.013922
```

