# getJobMessage {#getjobmessage}

## Syntax {#syntax}

`getJobMessage(jobId)`

## Arguments {#arguments}

**jobId** is a string indicating the batch job ID.

## Details {#details}

Retrieve the intermediate messages from a batch job. For details about batch jobs please refer to [Batch Job Management](../../Maintenance/BatchJobManagement.md). If the return value exceeds 65535 bytes, it will be returned as a BLOB type \(64 MB at max\); otherwise, it will be returned as a STRING type \(64 kb at max\).

## Examples {#examples}

```
def job1(n){
   s = 0
   for (x in 1 : n) {
       s += sum(sin rand(1.0, 100000000)-0.5)
       print("iteration " + x + " " + s)
   }
   return s
}
job1_ID=submitJob("job1_ID","", job1, 100);
```

Run the following command after the job is completed.

```
getJobMessage(job1_ID);

/* output:
2025-05-26 14:44:58.090748 Start the job [job1_ID202505260000]: job1
2025-05-26 14:44:59.394245 iteration 1 -2067.639360414350903
2025-05-26 14:45:00.571536 iteration 2 -3394.027760215838497
2025-05-26 14:45:01.728218 iteration 3 -6658.143178910555434
2025-05-26 14:45:02.955152 iteration 4 -9995.435727637650415
2025-05-26 14:45:04.362283 iteration 5 -8653.510696739111153
2025-05-26 14:45:05.542019 iteration 6 -10801.809641761219609
2025-05-26 14:45:06.702139 iteration 7 -12924.020454809666262
2025-05-26 14:45:07.850191 iteration 8 -10882.168276451939163
2025-05-26 14:45:09.060107 iteration 9 -14318.061736551684589
2025-05-26 14:45:10.428853 iteration 10 -11516.30579954075074
2025-05-26 14:45:11.570470 iteration 11 -13945.02455184262908
2025-05-26 14:45:12.706159 iteration 12 -15082.415793091910018
2025-05-26 14:45:13.845771 iteration 13 -16508.837934508221223
2025-05-26 14:45:14.980443 iteration 14 -12171.185820641085228
2025-05-26 14:45:16.133074 iteration 15 -11497.140285110303011
2025-05-26 14:45:17.305225 iteration 16 -12546.300852946240411
2025-05-26 14:45:18.469218 iteration 17 -8682.138463782639519
2025-05-26 14:45:19.636227 iteration 18 -8287.05071118341948
2025-05-26 14:45:20.797512 iteration 19 -6045.8953755881721
2025-05-26 14:45:21.989929 iteration 20 -1587.853404830938416
2025-05-26 14:45:23.366825 iteration 21 -1061.898133246364068
2025-05-26 14:45:24.509909 iteration 22 -5604.016581881107413
2025-05-26 14:45:25.658594 iteration 23 -681.276543087000391
2025-05-26 14:45:26.814315 iteration 24 798.217304283653447
2025-05-26 14:45:27.967876 iteration 25 -2357.82192257714496
2025-05-26 14:45:29.122764 iteration 26 1474.997463642485854
2025-05-26 14:45:30.264584 iteration 27 2351.139591280943477
2025-05-26 14:45:31.408370 iteration 28 1037.512168873698328
2025-05-26 14:45:32.548303 iteration 29 3893.945455537286761
2025-05-26 14:45:33.699278 iteration 30 4148.650282345925006
2025-05-26 14:45:34.894419 iteration 31 4031.307766634015024
2025-05-26 14:45:36.285051 iteration 32 4107.605624560140313
2025-05-26 14:45:37.452961 iteration 33 5929.91120327810222
2025-05-26 14:45:38.623867 iteration 34 9425.642810558107157
2025-05-26 14:45:39.791290 iteration 35 13047.809822686220286
2025-05-26 14:45:40.965689 iteration 36 10245.933230357943102
2025-05-26 14:45:42.117447 iteration 37 5432.54276188393851
2025-05-26 14:45:43.253473 iteration 38 5227.81294757969772
2025-05-26 14:45:44.241254 iteration 39 1356.898505138993641
2025-05-26 14:45:44.860755 iteration 40 -1671.878041062590909
2025-05-26 14:45:45.484119 iteration 41 -1021.138518814122107
2025-05-26 14:45:46.108090 iteration 42 -2321.149447111632525
2025-05-26 14:45:46.720242 iteration 43 -5246.586195028939982
2025-05-26 14:45:47.339880 iteration 44 -8492.119388688672188
2025-05-26 14:45:47.994839 iteration 45 -8663.850570230377343
2025-05-26 14:45:48.798468 iteration 46 -10024.085162459703497
2025-05-26 14:45:49.416817 iteration 47 -7627.128519907962072
2025-05-26 14:45:50.050123 iteration 48 -8859.465736911144631
2025-05-26 14:45:50.696957 iteration 49 -11600.588771286853443
2025-05-26 14:45:51.332706 iteration 50 -12023.426188408715461
2025-05-26 14:45:51.958107 iteration 51 -13738.331148613655386
2025-05-26 14:45:52.574174 iteration 52 -14245.913822854639875
2025-05-26 14:45:53.228183 iteration 53 -15609.22655546905662
2025-05-26 14:45:53.840108 iteration 54 -14109.554485099233716
2025-05-26 14:45:54.455551 iteration 55 -15457.235974196633833
2025-05-26 14:45:55.109167 iteration 56 -14926.928231457419315
2025-05-26 14:45:55.901304 iteration 57 -13535.493685042154538
2025-05-26 14:45:56.512054 iteration 58 -11137.324502514182313
2025-05-26 14:45:57.126833 iteration 59 -8467.404657879153091
2025-05-26 14:45:57.742143 iteration 60 -1746.003070659520744
2025-05-26 14:45:58.353437 iteration 61 -3325.876159699668278
2025-05-26 14:45:58.966068 iteration 62 588.700051641846584
2025-05-26 14:45:59.574346 iteration 63 -5367.267372965314279
2025-05-26 14:46:00.185607 iteration 64 -5910.796992469990073
2025-05-26 14:46:00.828945 iteration 65 -3960.193144167483296
2025-05-26 14:46:01.458748 iteration 66 122.939722062535111
2025-05-26 14:46:02.128915 iteration 67 -704.828146272833123
2025-05-26 14:46:02.955747 iteration 68 3864.606686010478824
2025-05-26 14:46:03.584085 iteration 69 5186.69739255679724
2025-05-26 14:46:04.210760 iteration 70 5384.310290306410024
2025-05-26 14:46:04.832343 iteration 71 3535.338795232024494
2025-05-26 14:46:05.451344 iteration 72 7529.76101041288075
2025-05-26 14:46:06.070711 iteration 73 5539.502143333455023
2025-05-26 14:46:06.719013 iteration 74 7597.268444337500113
2025-05-26 14:46:07.342229 iteration 75 14728.821072668564738
2025-05-26 14:46:07.979907 iteration 76 18934.636409439837734
2025-05-26 14:46:08.596204 iteration 77 19498.750036070654459
2025-05-26 14:46:09.252392 iteration 78 19268.594342755670368
2025-05-26 14:46:10.059616 iteration 79 20036.702738540243444
2025-05-26 14:46:10.734090 iteration 80 24399.283123330875241
2025-05-26 14:46:11.401129 iteration 81 26353.387390017069265
2025-05-26 14:46:12.020258 iteration 82 25021.36744718257978
2025-05-26 14:46:12.640379 iteration 83 20515.896296028589858
2025-05-26 14:46:13.271550 iteration 84 18948.980154855420551
2025-05-26 14:46:13.888417 iteration 85 22251.157044437986769
2025-05-26 14:46:14.509057 iteration 86 21076.744112906457303
2025-05-26 14:46:15.129712 iteration 87 19794.661956942076358
2025-05-26 14:46:15.750538 iteration 88 20416.494072026296635
2025-05-26 14:46:16.401382 iteration 89 19871.931658841131138
2025-05-26 14:46:17.209955 iteration 90 18276.697674308263231
2025-05-26 14:46:17.828958 iteration 91 19967.525665167577244
2025-05-26 14:46:18.461022 iteration 92 22098.668749747052061
2025-05-26 14:46:19.079399 iteration 93 17969.401810196610313
2025-05-26 14:46:19.711974 iteration 94 18239.368392132648295
2025-05-26 14:46:20.358000 iteration 95 18944.493373054185212
2025-05-26 14:46:21.011468 iteration 96 14969.713016859974231
2025-05-26 14:46:21.648286 iteration 97 12863.562367756972889
2025-05-26 14:46:22.289103 iteration 98 12659.014405440735572
2025-05-26 14:46:22.917878 iteration 99 14069.1513439974442
2025-05-26 14:46:22.917878 The job is done.
*/
*/
```

