# getGroupAccessByCluster {#getGroupAccessByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getGroupAccessByCluster(groupIds, clusterName)`

## Arguments {#arguments}

**groupIds** is a STRING scalar or vector, indicating group name\(s\).

**clusterName** is a STRING scalar or vector, indicating cluster name\(s\).

## Details {#details}

Get the privileges for specified user group. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A table with the same structure as the return value of the `getGroupAccess` function.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getGroupAccessByCluster(["group2"], "MoMSender")  
```

|groupName|users|ACCESS\_READ|ACCESS\_INSERT|ACCESS\_UPDATE|ACCESS\_DELETE|VIEW\_EXEC|SCRIPT\_EXEC|TEST\_EXEC|DBOBJ\_CREATE|...|
|---------|-----|------------|--------------|--------------|--------------|----------|------------|----------|-------------|---|
|group2|user2|none|allow|none|none|none|none|none|none|...|

Related Function: [getGroupAccess](getGroupAccess.md)

