# getEnv {#getenv}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getEnv(name, [default])`

## Arguments {#arguments}

**name** is a STRING scalar indicating the name of an environment variable.

**default** is a STRING scalar indicating the value to be returned when the environment variable does not exist. If it is unspecified, return an empty string.

## Details {#details}

Return the value of the specified environment variable. Otherwise return *default*.

## Examples {#examples}

```
getEnv("path")
// output: C:\ProgramData\DockerDesktop\version-bin;C:\Program Files\Docker\Docker\Resources\bin;

getEnv("JAVA_HOME");
// output: C:\Program Files\Java\jdk1.8.0_191

getEnv("not_exist","not exist")
// output: not exist
```

