# getDFSTablesByDatabase {#getdfstablesbydatabase}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getDFSTablesByDatabase(directory)`

## Arguments {#arguments}

**directory** is the directory where a DFS database is located.

## Details {#details}

This functions returns a vector that lists tables under the specified DFS directory.

From version 1.30.21/2.00.9 onwards,

-   For an administrator, it returns all DFS tables under the specified database on the current node.
-   When executed by a non-admin user, it will return:
    -   All DFS tables in databases where the user has any of the following permissions:DB\_OWNER, DB\_MANAGE, DB\_READ, DB\_WRITE, DB\_INSERT, DB\_UPDATE, DB\_DELETE.
    -   Within the specified database,the DFS tables where the user has any of the following permissions: TABLE\_READ, TABLE\_INSERT, TABLE\_WRITE, TABLE\_UPDATE, or TABLE\_DELETE.

## Examples {#examples}

```
getDFSTablesByDatabase("dfs://db")
// output: ["dfs://db/dt", "dfs://db/dt1"]
```

