# getComputeGroupChunksStatus {#getComputeGroupChunksStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getComputeGroupChunksStatus([computeGroup])`

## Arguments {#arguments}

**computeGroup** \(optional\) is a string indicating the compute group.

## Details {#details}

This function obtains the metadata about all database chunks \(file chunks and tablet chunks\) on the compute nodes. It must be executed on a controller.

**Return value**: A table containing the following columns:

-   chunkId: Chunk ID.
-   file: Chunk path.
-   routedTo: Compute node to which queries are routed.
-   cachedOn: Compute node on which the chunk is cached, in the format `alias:[version]`. For example, orca2:\[29\] means the compute node orca2 caches chunk data of version 29.
-   computeGroup: Compute group\(s\) where the chunk is cached.
-   size: Disk space occupied by the file chunk \(in Bytes\). Return 0 for a tablet chunk. Use [getTabletsMeta](getTabletsMeta.md) to check the disk usage of a tablet chunk.
-   version: Version number of the current chunk.
-   vcLength: Length of the version chain.
-   versionChain: Version chain of the chunk, e.g. "18441:76:1:346 -&gt; 18441:0:0:346 -&gt; ".
-   state: Chunk state. It can be
    -   CONSTRUCTING: in transaction.
    -   RECOVERING: recovering.
    -   COMPLETE: transaction completed.
-   dataNodeReplicas: Replica information of the chunk on data nodes.
-   dataNodeReplicaCount: Number of replica\(s\) on data nodes.
-   lastUpdated: Last modification timestamp.
-   permission: Chunk permission. It can be READ\_WRITE \(default\) and READ\_ONLY. Chunks that are being transferred or stored in S3 are READ\_ONLY.

## Examples {#examples}

``` {#codeblock_mzf_3qv_fdc}
getComputeGroupChunksStatus()
```

|chunkId|path|routedTo|cachedOn|computeGroup|size|version|vcLength|versionChain|state|dataNodeReplicas|dataNodeReplicaCount|lastUpdated|permission|
|-------|----|--------|--------|------------|----|-------|--------|------------|-----|----------------|--------------------|-----------|----------|
|0|abec288a-49f7-61b9-464e-56bf134c8340|/Storage\_compute\_separation\_tsdb/20120110/Key19/2|orca3|\[NOT CACHED\]|orca|0|1|1|1466:0:1:1466 -&gt;|COMPLETE|dnode2:1:0:false:0|1|2024.10.12 17:26:51.757|
|1|fdb95a8e-72f0-21a7-0443-2cbe02feeca2|/Storage\_compute\_separation\_tsdb/20120229/Key1/2|orca1|\[NOT CACHED\]|orca|0|1|1|1463:0:1:1463 -&gt;|COMPLETE|dnode3:1:0:false:0|1|2024.10.12 17:26:51.708|
|2|55020019-8b2c-75a1-3b40-7ad2469abe48|/Storage\_compute\_separation\_tsdb/20120110/Key13/2|orca3|\[NOT CACHED\]|orca|0|1|1|1458:0:1:1458 -&gt;|COMPLETE|dnode3:1:0:false:0|1|2024.10.12 17:26:51.618|
|3|96678f5f-6ae5-2b98-9944-5d4370473dee|/Storage\_compute\_separation\_tsdb/20120110/Key7/2|orca2|\[NOT CACHED\]|orca|0|1|1|1456:0:1:1456 -&gt;|COMPLETE|dnode1:1:0:false:0|1|2024.10.12 17:26:51.583|

