# getClusterChunksStatus {#getclusterchunksstatus}

## Syntax {#section_ehk_qw1_dzb .section}

`getClusterChunksStatus()`

## Details {#section_ufz_qw1_dzb .section}

This function obtains the metadata about all database chunks \(file chunks and tablet chunks\) on the data nodes in a cluster. It can be executed only on a controller. It returns a table containing the following columns:

-   chunkId: the chunk ID.

-   file: the chunk path.

-   size: The disk space occupied by the file chunk \(in Bytes\). Return 0 for a tablet chunk. Use [getTabletsMeta](getTabletsMeta.md) to check the disk usage of a tablet chunk.

-   version: the version number of the current chunk.

-   vcLength: length of the version chain.

-   versionChain: version chain of the chunk, e.g. "18441:76:1:346 -&gt; 18441:0:0:346 -&gt; ", where

    |18441|76|1|346|
    |-----|---|---|---|
    |cid \(chunk ID\)|chunk size|version number|sid \(snapshot ID\)|

-   state: the chunk state. It can be

    -   CONSTRUCTING: in transaction;

    -   RECOVERING: recovering;

    -   COMPLETE: transaction completed.

-   replicas: Information about the distribution of data replicas. Each replica is formatted as `nodeAlias:replicaVersion:corrupted:inResolution:timestamp:volumeID`. Multiple replicas are separated by commas.

-   replicaCount: the number of replica\(s\).

-   lastUpdated: the timestamp for last update. Note that lastUpdated column is supported since version 1.30.20/2.00.1. For a chunk created before, it returns a null value.

-   permission: the chunk permission. It can be READ\_WRITE \(default\), READ\_ONLY, WRITE\_ONLY, and UNKNOWN. Chunks that are being transferred or stored in S3 are READ\_ONLY.


For READ\_ONLY chunks:

-   Data cannot be appended or updated. Only drop operations can be performed to delete records. Transaction is supported in the READ\_ONLY chunks \(except for those stored in S3\).
-   Operations such as recovery and rebalance cannot be performed.
-   Level files in the TSDB engine cannot be merged.

## Examples {#section_azb_zw1_dzb .section}

``` {#codeblock_j4y_zw1_dzb}
rpc(getControllerAlias(), getClusterChunksStatus);
```

|chunkId|file|size|version|vcLength|versionChain|state|replicas|replicaCount|lastUpdated|permission|
|-------|----|----|-------|--------|------------|-----|--------|------------|-----------|----------|
|092d5e12-e595-6f…|/testDB/pt2.tbl|49|1|1|2052:49:1 -&gt;|COMPLETE|P1-node1:1:0,P2-…|2|2022.03.31T18:09:41.138|READ\_WRITE|
|42936e31-8be0-fa…|/testDB/9/i|0|2|2|2053:0:2 -&gt; 2051…|COMPLETE|P3-node1:2:0,P1-…|2|2022.03.31T18:09:41.138|READ\_WRITE|
|d31e6b47-18f0-37…|/testDB/7/i|0|2|2|2053:0:2 -&gt; 2051…|COMPLETE|P1-node1:2:0,P2-…|2|2022.03.31T18:09:41.138|READ\_WRITE|
|647a5fd6-cd85-3b…|/testDB/6/i|0|2|2|2053:0:2 -&gt; 2051…|COMPLETE|P1-node1:2:0,P3-…|2|2022.03.31T18:09:41.138|READ\_WRITE|
|8bec6445-bc6d-36…|/testDB/5/i|0|2|2|2053:0:2 -&gt; 2051…|COMPLETE|P2-node1:2:0,P3-…|2|2022.03.31T18:09:41.138|READ\_WRITE|
|ca690ba5-be73-a6…|/testDB/4/i|0|2|2|2053:0:2 -&gt; 2051…|COMPLETE|P3-node1:2:0,P1-…|2|2022.03.31T18:09:41.138|READ\_WRITE|

