# getChunkPath {#getchunkpath}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getChunkPath(ds)`

## Arguments {#arguments}

**ds** is one or multiple data sources.

## Details {#details}

Return the paths of the chunks that the given data sources represent.

## Examples {#examples}

```
if(existsDatabase("dfs://valuedb")){
  dropDatabase("dfs://valuedb")
}

db=database("dfs://valuedb", VALUE, 1..10)
n=1000000
t=table(rand(1..10, n) as id, rand(100.0, n) as val)
pt=db.createPartitionedTable(t, `pt, `id).append!(t);
ds=sqlDS(<select * from pt where id in 1..3>)
getChunkPath(ds);

// output: ["/valuedb/1","/valuedb/2","/valuedb/3"]
```

