# getCatalogsByCluster {#getCatalogsByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getCatalogsByCluster(clusterName)`

## Arguments {#arguments}

**clusterName** is a STRING scalar or vector, indicating the cluster name\(s\).

## Details {#details}

Return all catalogs in the specified cluster. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A STRING vector.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
// MoMSender cluster:
createCatalog("catalog1")
createCatalog("catalog2")
createCatalog("catalog3")
createCatalog("catalog4")
   
// MoM cluster:
getCatalogsByCluster("MoMSender")
// Output: ["catalog1","catalog2","catalog3","catalog4"]    
```

