# getCacheEngineStat {#getCacheEngineStat}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getCacheEngineStat()`

## Arguments {#arguments}

None

## Details {#details}

Get the status of the OLAP cache engine on the current node. The function can only be called on the data node.

Return a table containing the following columns:

-   chunkId: the chunk ID

-   physicalName: the physical name of the table to which the chunk belongs

-   timeSinceLastWrite: the time elapsed \(in milliseconds\) since last write

-   cachedRowsOfCompletedTxn: the number of cached records of completed transactions

-   cachedRowsOfUncompletedTxn: the number of cached records of uncompleted transactions. Note: For each chunk, only the last transaction may not have been completed.

-   cachedMemOfCompletedTxn: the memory usage \(in Bytes\) of completed transactions

-   cachedMemOfUncompletedTxn: the memory usage \(in Bytes\) of uncompleted transactions

-   cachedTids: list of transaction IDs \(tid\)


## Examples {#examples}

``` {#codeblock_nv4_5kt_hzb}
getCacheEngineStat()
```

|chunkId|physicalName|timeSinceLastWrite|cachedRowsOfCompletedTxn|cachedRowsOfUncompletedTxn|cachedMemOfCompletedTxn|cachedMemOfUncompletedTxn|cachedTids|
|-------|------------|------------------|------------------------|--------------------------|-----------------------|-------------------------|----------|
|e4558d3c-fa41-52b5-418b-94e26cb70a75|pt\_2|1056|222,386|0|3,558,176|0|2052|

