# geoWithin {#geoWithin}

## Syntax {#Syntax .section}

`geoWithin(X, polygonVertices, [containBoundary=true])`

## Arguments {#Arguments .section}

**X** is a POINT scalar/vector, indicating one or multiple points.

**polygonVertices** is a POINT vector, indicating a polygon.

**containBoundary** \(optional\) is a Boolean scalar, indicating whether the points on the polygon boundary are considered inside. The default value is true.

## Details {#Details .section}

Determine whether *X* lies inside or outside *polygonVertices*.

## Examples {#Examples .section}

``` {#codeblock_n3k_xtr_z1c}
point1 = point(1,1)
point2 = point(2,3)
point3 = point(2,1)
polygon = [point(0,0),point(0,2),point(2,2),point(2,0)]
geoWithin([point1,point2],polygon)
// output: [true,false,true]
geoWithin([point1,point2,point3],polygon,false)
// output: [true,false,false]
```

**Parent topic:**[Functions](../../Functions/category.md)

