# genShortGenomeSeq {#genshortgenomeseq}

## Syntax {#section_dk2_wv1_dzb .section}

`genShortGenomeSeq(X, window)`

Alias: genSGS

## Arguments {#section_gzc_xv1_dzb .section}

**X** is a STRING scalar or CHAR vector.

**window** is a positive integer in \[2,28\].

## Details {#section_jzj_yv1_dzb .section}

This function slides a window of fixed size \(based on the number of characters\) over the input DNA sequence. It encodes the characters in each window and returns an integral vector containing the encoded values. The returned vector has the same length as the number of characters in *X*.

**Note**:

-   This function adopts a forward sliding window approach, starting from the first character of the sequence. The sliding window moves by one character at a time. It first takes the current character, then the next character, continuing until window characters are included.

-   If *window* exceeds the total length of *X*, an empty integral vector is returned.


**Return value**:

|*window* Range|Return Type|
|--------------|-----------|
|\[2,4\]|FAST SHORT VECTOR|
|\[5,12\]|FAST INT VECTOR|
|\[13,28\]|FAST LONG VECTOR|

## Examples {#section_k4x_bw1_dzb .section}

``` {#codeblock_msq_cw1_dzb}
genShortGenomeSeq("NNNNNNNNTCGGGGCAT",3)
// output: [,,,,,,,,795,815,831,831,830,824,801,,]

genShortGenomeSeq("TCGGGGCATNGCCCG",4)
// output: [1135,1215,1279,1278,1272,1249,,,,,1258,1195,,,]

genShortGenomeSeq("GCCCGATNNNNN",6)
// output: [396972,395953,,,,,,,,,,]

genShortGenomeSeq("TCGATCGTCGATCGTCGATCGTCGATCGG",5)
// output: [328113,328390,328475,327789,328118,328411,328556,328113,328390,328475,327789,328118,328411,328556,328113,328390,328475,327789,328118,328411,328556,328113,328390,328475,327791,,,,]

genShortGenomeSeq("ACTT",8)
// output: [,,,]
```

Related functions: [encodeShortGenomeSeq](../e/encodeShortGenomeSeq.md), [decodeShortGenomeSeq](../d/decodeShortGenomeSeq.md)

**Parent topic:**[Functions](../../Functions/category.md)

