# gaussianKdePredict {#gaussianKdePredict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`gaussianKdePredict(model,X)`

## Arguments {#arguments}

**model** is a dictionary indicating the model generated by `gaussianKde`.

**X** is a numeric vector, matrix, tuple, or table indicating the data to be predicted. Its dimensions must be the same as those of the dataset used in `gaussianKde`.

## Details {#details}

Predict the probability density of the input data based on the model generated by `gaussianKde`.

**Return value**: A floating-point vector of the same size as the number of rows in *X*, indicating the prediction result of each data point in *X*.

## Examples {#examples}

The following example first uses the `gaussianKde` function to estimate the probability density of the input *trainset.txt*. based on the Gaussian kernel estimation and generate a model. Then, the `gaussianKdePredict` function is called to apply this model to another input file, *testset.txt*, to predict its probability density results.

``` {#codeblock_ogb_scg_1cc}
trainData = loadText("trainset.txt"," ");
testData = loadText("testset.txt"," ");
model = gaussianKde(trainData)
gaussianKdePredict(model, testData)
```

Output:

``` {#codeblock_dzv_xcg_1cc}
->[0.0623,0.0730,0.0336,0.0030,0.0001,0.0552....]
```

Related Function: [gaussianKde](gaussianKde.md)

## Appendix {#topic_l42_bdg_1cc}

[trainset.txt](../resources/trainset.txt)

[testset.txt](../resources/testset.txt)

