# garch {#garch}

## Syntax {#Syntax .section}

`garch(ds, endogColName, order, [maxIter=50])`

## Arguments {#Arguments .section}

**ds** is an in-memory table or a vector consisting of DataSource objects, containing the multivariate time series to be analyzed. *ds* cannot be empty.

**endogColName** is a string indicating the column names of the endogenous variables in *ds*.

**order** is a positive integral vector of length 2 indicating the orders. For example, order=\[1,2\] means p=1, q=2 for a GARCH model, where *p* is the order of the GARCH terms and *q* is the order of the ARCH terms.

**maxIter** \(optional\) is a positive integer indicating the maximum iterations. The default value is 50.

## Details {#Details .section}

Use the generalized autoregressive conditional heteroskedasticity \(GARCH\) model to model the conditional volatility of univariate time series.

**Return value**: Return a dictionary with the following keys:

-   volConstant: A floating-point scalar, representing the Vol Constant obtained through optimization.
-   returnsConstant: A floating-point scalar, representing the Returns Constant obtained through optimization.
-   archTerm: A floating-point vector, representing the ARCH Term obtained through optimization.
-   garchTerm: A floating-point vector, representing the GARCH Term obtained through optimization.
-   iterations: An integer representing the number of iterations.
-   aic: A floating-point scalar, representing the value of the AIC criterion.
-   bic: A floating-point scalar, representing the value of the BIC criterion.
-   nobs: An integer representing the number of observations in the time series, i.e., the amount of data used for fitting.
-   model: A dictionary containing the basic information of the fitted model, with the following members:
    -   order: A vector with 2 positive integers, representing the order of the model.
    -   endog: A floating-point matrix, representing the observed data converted from *ds*.
    -   coefficients: A floating-point vector, representing the values of the exogenous variables after fitting.
-   predict: The prediction function of the model. It can be called using `model.predict(x)`, where:
    -   model: A dictionary indicating the output of `garch`.
    -   x: A positive integer representing the prediction step.

## Examples {#Examples .section}

Analyze the data in the [macrodata.csv](../resources/macrodata.csv) file with garch model:

``` {#codeblock_rjj_mqh_fdc}
data = loadText("macrodata.csv");
model = garch(data, "realgdp", [1,1]);
print(model)

/* output:
volConstant->0.000005999433551
returnsConstant->0.008474617943101
archTerm->[0.70725452294378]
garchTerm->[0.248859733003604]
aic->-1353.789403416915774
bic->-1340.576183784679415
nobs->201
iterations->38
predict->garchPredict
state->order->[1,1]
endog->#0                
------------------
0.024942130816387 
-0.001192952110668
0.003494532654372 
...

start->[-12.023845501294935,-1.104702991485461,0.882087052766567,0.008474617943101]
*/
```

**Parent topic:**[Functions](../../Functions/category.md)

